#define ETG_S_IMPORT_INTERFACE_GENERIC
#define ETG_S_IMPORT_INTERFACE_PLATFORM
#include "etg_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_MCAN_TCU_UTIL
#include "trcGenProj/Header/MPDT_Config_Parsers.cpp.trc.h"
#endif

#include "MPDT_Config_Parsers.h"

#include <fstream>
#include <sstream>
#include <string>

#define MSG_CONFIG_FILE_PATH "/opt/bosch/tcu/mcan/json/mcan_msg_config.json"
#define MAP_CONFIG_FILE_PATH "/opt/bosch/tcu/mcan/json/mcan_map_config.json"


MPDT_Config_Parsers::MPDT_Config_Parsers()
{
	ETG_TRACE_USR1(("MPDT_Config_Parsers::MPDT_Config_Parsers() entered"));
	sJsonMap_Config_FilePath = MAP_CONFIG_FILE_PATH;
	sJsonMsg_Config_FilePath = MSG_CONFIG_FILE_PATH;

}

MPDT_Config_Parsers::~MPDT_Config_Parsers()
{
	ETG_TRACE_USR1(("MPDT_Config_Parsers::~MPDT_Config_Parsers() entered"));

}

unsigned short MPDT_Config_Parsers::LoadJsonDataFromFile(Json::Value& data,	std::string path)
{
	ETG_TRACE_USR1(("Trying to Load Data from %s",path.c_str()));
	std::ifstream Config(path.c_str());
	bool loadStatus = false;
	if(Config.good())
	{
		std::ifstream binaryInputData(path.c_str(), std::ifstream::binary);
		Json::Reader reader;

		loadStatus = reader.parse(binaryInputData, data, false);
		if(loadStatus == true)
		{
			ETG_TRACE_USR1(("%s file data Loaded to Json Object \n",path.c_str()));
		}
		else
		{
			ETG_TRACE_USR1(("Failed to load the data From file %s ",path.c_str()));
		}
	}
	else
	{
		ETG_TRACE_USR1(("Error occured while trying to read the file %s",path.c_str()));
	}

	return loadStatus;
}

tBool MPDT_Config_Parsers::bGetListofAllowedMsgs(tU8 u8Brand,tU8 u8EngineType,tU8 u8TCUAvailability,tU8 u8Region,std::string sArchitecture,std::vector<tU16> &oAllowedMsgsList,std::string &sKeyPrepared)
{
	Json::Value oAllMsgConfigurations;
	tBool parseStatus = FALSE;
	ETG_TRACE_USR1(("MPDT_Config_Parsers::bGetListofAllowedMsgs Entered"));

	if(TRUE == bReadlistofMsgItems(oAllMsgConfigurations))
	{
		std::string sFinalString;
		ETG_TRACE_USR1(("bReadlistofMsgItems parsing success"));

		std::string sBrand;
		if(FALSE ==  bGetBrandName(sU8ToStr(u8Brand),sBrand))
		{
			ETG_TRACE_ERR(("Invalid brand "));
			return FALSE;
		}

		ETG_TRACE_USR1(("Brand Name:%s",sBrand.c_str()));

		std::string sVechiletypeName;
		if(FALSE ==  bGetVehicleModeType(sU8ToStr(u8EngineType),sVechiletypeName))
		{
			ETG_TRACE_ERR(("Invalid VechicleType "));
			return FALSE;
		}

		ETG_TRACE_USR1(("Engine type :%s",sVechiletypeName.c_str()));

		std::string sTcuStatusName;
		if(FALSE ==  bGetTcuAvailabilityStatus(sU8ToStr(u8TCUAvailability),sTcuStatusName))
		{
			ETG_TRACE_ERR(("Invalid TcuStatusName "));
			return FALSE;
		}
		ETG_TRACE_USR1(("Tcu Availability Status:%s",sTcuStatusName.c_str()));

		std::string sRegionName;
		if(FALSE ==  bGetRegion(u8Region,sBrand,sRegionName,sArchitecture))
		{
			ETG_TRACE_ERR(("Invalid Region "));
			return FALSE;
		}

		std::string sTCUType;
		if(FALSE ==  bGetTcuType(u8Brand,sArchitecture,sTCUType))
		{
			ETG_TRACE_ERR(("Invalid TCU Type "));
			return FALSE;
		}


		ETG_TRACE_USR1(("Region type :%s",sRegionName.c_str()));

		sFinalString.append(sTCUType);
		sFinalString.append("_");
		sFinalString.append(sBrand);
		sFinalString.append("_");
		sFinalString.append(sVechiletypeName);
		sFinalString.append("_");
		sFinalString.append(sTcuStatusName);
		sFinalString.append("_");
		sFinalString.append(sRegionName);

		ETG_TRACE_USR1(("sFinalString is :%s",sFinalString.c_str()));
		sKeyPrepared = sFinalString;
		parseStatus = bReadlistofAllowedMsgs(oAllMsgConfigurations, sFinalString,oAllowedMsgsList);
		if(TRUE == parseStatus)
		{
			return parseStatus;
		}

	}
	return FALSE;
}

tBool MPDT_Config_Parsers::bGetBrandName(std::string sBrandValue,std::string &sBrandName)
{
	ETG_TRACE_USR1(("bGetBrandName entered"));
	Json::Value oBrandData;

	tBool bParseStatus = bReadMapItems("BRAND",oBrandData);
	if(TRUE == bParseStatus)
	{
		ETG_TRACE_USR1(("We recieved Brand_Type "));
		bParseStatus = oParseUtil.getString(oBrandData,sBrandValue.c_str(),sBrandName);
		if(TRUE == bParseStatus)
		{
			return TRUE;
		}
		else
		{
			ETG_TRACE_USR1(("Unable to Get Brand value for :: %s",sBrandValue.c_str()));
		}

	}
	ETG_TRACE_USR1(("FAILED TO GET BRANDS "));
	return FALSE;
}

tBool MPDT_Config_Parsers::bGetVehicleModeType(std::string sVechiletypeValue,std::string& sVechiletypeName)
{
	ETG_TRACE_USR1(("MPDT_Config_Parsers::bGetVehicleModeType() entered"));
	Json::Value oVechiletype;
	tBool bParseStatus = bReadMapItems("Engine_Type",oVechiletype);
	if(TRUE == bParseStatus)
	{
		ETG_TRACE_USR1(("We recieved Engine_Type "));
		bParseStatus = oParseUtil.getString(oVechiletype,sVechiletypeValue.c_str(),sVechiletypeName);
		if(TRUE == bParseStatus)
		{
			return TRUE;
		}
		else
		{
			ETG_TRACE_USR1(("Unable to Get  value for Engine_Type:: %s",sVechiletypeValue.c_str()));
		}

	}
	ETG_TRACE_USR1(("FAILED TO GET Engine_Type "));
	return FALSE;

}

tBool MPDT_Config_Parsers::bGetTcuAvailabilityStatus(std::string sTcuStatusValue,std::string& sTcuStatusName)
{
	ETG_TRACE_USR1(("MPDT_Config_Parsers::bGetTcuAvailabilityStatus() entered"));
	Json::Value oTcuStatus;
	tBool bParseStatus = bReadMapItems("TCU_Availability",oTcuStatus);
	if(TRUE == bParseStatus)
	{
		ETG_TRACE_USR1(("We recieved TCU_Availability "));
		bParseStatus = oParseUtil.getString(oTcuStatus,sTcuStatusValue.c_str(),sTcuStatusName);
		if(TRUE == bParseStatus)
		{
			return TRUE;
		}
		else
		{
			ETG_TRACE_USR1(("Unable to Get  value for TCU_Availability:: %s",sTcuStatusValue.c_str()));
		}

	}
	return FALSE;

}

tBool MPDT_Config_Parsers::bGetRegion(tU8 u8RegionValue, std::string sOEMName,std::string &sRegionName, const std::string sArchitecture)
{
	ETG_TRACE_USR1(("MPDT_Config_Parsers::bGetRegion() entered"));
	Json::Value oRegion;
	tBool bParseStatus = bReadMapItems("Region_Map",oRegion);
	if(TRUE == bParseStatus)
	{
		ETG_TRACE_USR1(("MPDT_Config_Parsers::bGetRegion() :: Checking OEMBased Region Names"));
		Json::Value oOEMArchBasedRegions;
		bParseStatus = oParseUtil.getJSONArray(oRegion,"OEM_ARCH_BASED_MAP",oOEMArchBasedRegions);
		if(TRUE == bParseStatus)
		{

			if(TRUE== bGetRegionNameByOEMArch(oOEMArchBasedRegions,u8RegionValue,sOEMName,sRegionName,sArchitecture))
			{
				return TRUE;
			}
		}

	}
	return FALSE;

}


std::string MPDT_Config_Parsers::sU8ToStr(tU8 u8Val)
{
	ETG_TRACE_USR1(("MPDT_Config_Parsers::sU8ToStr() entered"));
	std::stringstream ss;
	ss<<(tU16)u8Val;
	std::string sStr = ss.str();
	ETG_TRACE_USR1((" Converted Str :: %s",sStr.c_str()));
	return sStr;
}

 tBool MPDT_Config_Parsers::bReadAllMaps(Json::Value &oData)
{
	 ETG_TRACE_USR1(("MPDT_Config_Parsers::bReadAllMaps() entered"));
	 Json::Value oReadData;
	 if(TRUE == LoadJsonDataFromFile(oReadData,sJsonMap_Config_FilePath))
	 {
		 tBool parseStatus = oParseUtil.getJSONObject(oReadData,"Maps",oData);
		 ETG_TRACE_USR1((" Maps Parsestats :: %d",parseStatus));
		 return parseStatus;
	 }
	 else
	 {
		 ETG_TRACE_USR1(("Loading of Map config Json file failed"));
		 return FALSE;

	 }
}

tBool MPDT_Config_Parsers::bReadMapItems(std::string ItemName,Json::Value& oMapItem)
{
	ETG_TRACE_USR1(("MPDT_Config_Parsers::bReadMapItems() entered"));
	Json::Value oAllMapItem;
	if(TRUE == bReadAllMaps(oAllMapItem))
	{
		tBool parseStatus = oParseUtil.getJSONObject(oAllMapItem,ItemName.c_str(),oMapItem);
		ETG_TRACE_USR1(("  Parsestats :: %d for %s",parseStatus,ItemName.c_str()));
		return parseStatus;
	}
	else
	{
		ETG_TRACE_ERR(("Failed to Read ALL Maps items"));
		return FALSE;
	}
}

tBool MPDT_Config_Parsers::bReadlistofMsgItems(Json::Value& oData)
{
	ETG_TRACE_USR1(("MPDT_Config_Parsers::bReadlistofMsgItems() entered"));
	Json::Value oReadData;
	if(TRUE == LoadJsonDataFromFile(oReadData,sJsonMsg_Config_FilePath))
	{
		tBool parseStatus = oParseUtil.getJSONObject(oReadData,"MPDT_MSG_CONFIG",oData);
		ETG_TRACE_USR1(("MPDT_Config_Parsers::bReadlistofMsgItems parseStatus:%d", parseStatus));
		return parseStatus;
	}
	else
	{
		ETG_TRACE_USR1(("Loading of Msg config Json file failed"));
		return FALSE;

	}

}

tBool MPDT_Config_Parsers::bReadlistofAllowedMsgs(Json::Value& oData,std::string sFinalString, std::vector<tU16>& oAllowedMsgsList)
{
	ETG_TRACE_USR1(("MPDT_Config_Parsers::bReadlistofAllowedMsgs() entered"));
	Json::Value tAllowedMsgs;
	tBool parseStatus = oParseUtil.getJSONArray(oData,sFinalString.c_str(),tAllowedMsgs);
	if(TRUE == parseStatus)
	{
		for(unsigned index =0;index<tAllowedMsgs.size(); index++)
		{
			oAllowedMsgsList.push_back((tU16)tAllowedMsgs[index].asInt());
		}
		return TRUE;
	}
	else
	{
		return FALSE;
	}

}

tBool MPDT_Config_Parsers::bGetRegionCode(tU8 u8Region,std::string& sRegionCode)
{
	ETG_TRACE_USR1(("MPDT_Config_Parsers::bGetRegionCode() entered"));

	std::string sRegionValue = sU8ToStr(u8Region);
	Json::Value oRegionCode;
	tBool bParseStatus = bReadMapItems("Region_Code_Map",oRegionCode);
	if(TRUE == bParseStatus)
	{
		bParseStatus = oParseUtil.getString(oRegionCode,sRegionValue.c_str(),sRegionCode);
		if(TRUE == bParseStatus)
		{
			return TRUE;
		}

	}
	return FALSE;
}

tBool MPDT_Config_Parsers::bGetMCANTrigger(tU8 u8VCANDiversity, tU8 u8Brand,tU8& u8TriggerType)
{
	ETG_TRACE_USR1(("MPDT_Config_Parsers::bGetMCANTrigger() entered"));
	Json::Value oNode;
	if(TRUE == bGetChannelConf(u8VCANDiversity,u8Brand,oNode))
	{
		tU32 tmp;
		if((TRUE == bGetChannelConfvalues(oNode,"MCAN_TRIGGER",tmp)))
		{
			u8TriggerType = (tU8)tmp;
			return TRUE;
		}

	}
	return FALSE;
}

tBool MPDT_Config_Parsers::bGetITCMaskTrigger(tU8 u8VCANDiversity, tU8 u8Brand,tU8& u8TriggerType)
{
	ETG_TRACE_USR1(("MPDT_Config_Parsers::bGetITCMaskTrigger() entered"));
	Json::Value oNode;
	if(TRUE == bGetChannelConf(u8VCANDiversity,u8Brand,oNode))
	{
		tU32 tmp;
		if((TRUE == bGetChannelConfvalues(oNode,"ITC_MASK_ON",tmp)))
		{
			u8TriggerType = (tU8)tmp;
			return TRUE;
		}

	}

	return FALSE;

}

tBool MPDT_Config_Parsers::bGetCOMM_ERR_ITC(tU8 u8VCANDiversity, tU8 u8Brand,tU32& u32ITC)
{
	ETG_TRACE_USR1(("MPDT_Config_Parsers::bGetCOMM_ERR_ITC() entered"));
	Json::Value oNode;
	if(TRUE == bGetChannelConf(u8VCANDiversity,u8Brand,oNode))
	{
		if((TRUE == bGetChannelConfvalues(oNode,"COMM_ERR_ITC",u32ITC)))
		{
			return TRUE;
		}

	}

	return FALSE;
}

tBool MPDT_Config_Parsers::bGetDDATA_ERR_ITC(tU8 u8VCANDiversity, tU8 u8Brand,tU32& u32ITC)
{
	ETG_TRACE_USR1(("MPDT_Config_Parsers::bGetDDATA_ERR_ITC() entered"));
	Json::Value oNode;
	if(TRUE == bGetChannelConf(u8VCANDiversity,u8Brand,oNode))
	{
		if((TRUE == bGetChannelConfvalues(oNode,"DDATA_ERR_ITC",u32ITC)))
		{
			return TRUE;
		}

	}

	return FALSE;
}

tBool MPDT_Config_Parsers::bGetCDATA_ERR_ITC(tU8 u8VCANDiversity, tU8 u8Brand,tU32& u32ITC)
{
	ETG_TRACE_USR1(("MPDT_Config_Parsers::bGetCDATA_ERR_ITC() entered"));
	Json::Value oNode;
	if(TRUE == bGetChannelConf(u8VCANDiversity,u8Brand,oNode))
	{
		if((TRUE == bGetChannelConfvalues(oNode,"CDATA_ERR_ITC",u32ITC)))
		{
			return TRUE;
		}
	}
	return FALSE;
}

tBool MPDT_Config_Parsers::bGetVCANDiverityStr(std::string sVCANDivVal,std::string& sVCANDivName)
{
	ETG_TRACE_USR1(("MPDT_Config_Parsers::bGetVCANDiverityStr() entered"));
	Json::Value oDivConfig;
	tBool bParseStatus = bReadMapItems("VCAN_SLOT_MAP",oDivConfig);

	if(TRUE == bParseStatus)
	{
		bParseStatus = oParseUtil.getString(oDivConfig,sVCANDivVal.c_str(),sVCANDivName);
		if(TRUE == bParseStatus)
		{
			return TRUE;
		}
		else
		{
			ETG_TRACE_USR1(("Unable to Get VCAN Diversity value for :: %s",sVCANDivVal.c_str()));
		}

	}

	return FALSE;

}

tBool MPDT_Config_Parsers::bReadChannelConfig(Json::Value& oChnlConfig)
{
	ETG_TRACE_USR1(("MPDT_Config_Parsers::bReadChannelConfig() entered"));
	tBool bParseStatus = bReadMapItems("MCAN_CHANNEL_CONFIGURATION",oChnlConfig);
	return bParseStatus;
}

tBool MPDT_Config_Parsers::bGetChannelConf(tU8 u8VCANDiversity, tU8 u8Brand,Json::Value& oNode)
{
	ETG_TRACE_USR1(("MPDT_Config_Parsers::bGetChannelConf() entered"));

	Json::Value oTmp;
	if(TRUE == bReadChannelConfig(oTmp))
	{
		Json::Value oByVCANDiv;
		if(TRUE == bGetChannelConfByVCANDiv(u8VCANDiversity,oTmp,oByVCANDiv))
		{
			if(TRUE == bGetChannelConfByOEM(u8Brand,oByVCANDiv,oNode))
			{
				return TRUE;
			}
		}

	}
	return FALSE;
}

tBool MPDT_Config_Parsers::bGetChannelConfByVCANDiv(tU8 u8VCANDiversity,Json::Value &oAllConf,Json::Value& oNode)
{
	ETG_TRACE_USR1(("MPDT_Config_Parsers::bGetChannelConfByVCANDiv() entered"));
	std::string VCANDiv;
	if(TRUE == bGetVCANDiverityStr(sU8ToStr(u8VCANDiversity),VCANDiv))
	{
		tBool parseStatus = oParseUtil.getJSONObject(oAllConf,VCANDiv.c_str(),oNode);
		ETG_TRACE_USR1((" VCAN Diversity Based Conf Parsestats :: %d",parseStatus));
		return parseStatus;
	}
	return FALSE;


}

tBool MPDT_Config_Parsers::bGetChannelConfByOEM(tU8 u8Brand,Json::Value &oConfByVCANDiv,Json::Value &oNode)
{
	ETG_TRACE_USR1(("MPDT_Config_Parsers::bGetChannelConfByOEM() entered"));
	std::string Brand;
	if(TRUE == bGetBrandName(sU8ToStr(u8Brand),Brand))
	{
		tBool parseStatus = oParseUtil.getJSONObject(oConfByVCANDiv,Brand.c_str(),oNode);
		ETG_TRACE_USR1((" OEM Diversity Based Conf Parsestats :: %d",parseStatus));

		return parseStatus;
	}

	return FALSE;

}

tBool MPDT_Config_Parsers::bGetChannelConfvalues(Json::Value& oNode,std::string sConfItemName,tU32 &u3Val)
{
	ETG_TRACE_USR1(("MPDT_Config_Parsers::bGetChannelConfvalues() entered"));
	ETG_TRACE_USR1(("We are trying to Get %s item ",sConfItemName.c_str()));
	tBool bParseStatus = oParseUtil.gettU32UInt(oNode,sConfItemName.c_str(),u3Val);
	if(TRUE == bParseStatus)
	{
		return TRUE;
	}
	else
	{
		ETG_TRACE_USR1(("Unable to Get value for :: %s",sConfItemName.c_str()));
	}
	return FALSE;

}

tBool MPDT_Config_Parsers::bGetRegionNameByOEMArch(Json::Value& oOEMArchBasedMapArray,const tU8 u8RegionCode, const std::string sOEMName,std::string &sRegionName, const std::string sArchitecture )
{
	ETG_TRACE_USR1(("MPDT_Config_Parsers::bGetRegionNameByOEM()"));
	tU8 u8SizeofOEMlist = oOEMArchBasedMapArray.size();
	ETG_TRACE_USR1(("MPDT_Config_Parsers::bGetRegionNameByOEM() :: Size of List :: %d",u8SizeofOEMlist));
	std::string sOEMArchName = sOEMName;
	sOEMArchName.append("_");
	sOEMArchName.append(sArchitecture);
	for(tU8 u8Index = 0; u8Index<u8SizeofOEMlist;u8Index++)
	{
		ETG_TRACE_USR1(("MPDT_Config_Parsers::bGetRegionNameByOEM():: Parsing All OEM Based Conf of %d",u8Index));
		Json::Value oOEMArchBasedRegions = oOEMArchBasedMapArray[u8Index];
		Json::Value oOEMArchNames;
		if(TRUE == oParseUtil.getJSONArray(oOEMArchBasedRegions,"OEM_ARCH_NAMES",oOEMArchNames))
		{
			ETG_TRACE_USR1(("MPDT_Config_Parsers::bGetRegionNameByOEM():: Recieved OEMArch lists of %d  ",u8Index));
			tU8 u8SizeofOEMNamelist = oOEMArchNames.size();
			for(tU8 u8OEMIndex = 0; u8OEMIndex<u8SizeofOEMNamelist;u8OEMIndex++)
			{
				std::string sConfigueredOEMArchName = oOEMArchNames[u8OEMIndex].asString();
				ETG_TRACE_USR1(("MPDT_Config_Parsers::bGetRegionNameByOEMArch():: Read OEM %s  ",sConfigueredOEMArchName.c_str()));
				if(sOEMArchName == sConfigueredOEMArchName)
				{
					ETG_TRACE_USR1(("MPDT_Config_Parsers::bGetRegionNameByOEMArch():: Found OEM  %s  in list ",sOEMArchName.c_str()));
					Json::Value oRegionMaps;
					if(TRUE == oParseUtil.getJSONArray(oOEMArchBasedRegions,"REGION_MAPPING",oRegionMaps))
					{
						ETG_TRACE_USR1(("MPDT_Config_Parsers::bGetRegionNameByOEM():: Checking all Region Maps for OEM  %s ",sOEMArchName.c_str()));
						if(TRUE == bGetRegionNameByRegionCode(oRegionMaps,u8RegionCode,sRegionName))
						{
							return TRUE;
						}
						else
						{
							ETG_TRACE_USR1(("Region name not found in the list, so considering current region as OTHER"));
							sRegionName = "OTHER";
							ETG_TRACE_USR1(("Returning %s as Region ",sRegionName.c_str()));
							return TRUE;
						}
					}
				}
			}
		}

	}

	return FALSE;

}

tBool MPDT_Config_Parsers::bGetRegionNameByRegionCode(Json::Value& oRegionMapingArray, const tU8 u8RegionCode,std::string& sRegionName)
{
	ETG_TRACE_USR1(("MPDT_Config_Parsers::bGetRegionNameByRegionCode() entered::"));

	tU8 u8SizeofRegionMappingArrayList = oRegionMapingArray.size();
	for(tU8 u8Index = 0; u8Index<u8SizeofRegionMappingArrayList;u8Index++)
	{
		ETG_TRACE_USR1(("Reading REGION MAP"));
		Json::Value oRegionConfigs = oRegionMapingArray[u8Index];
		Json::Value oRegions;
		if(TRUE == oParseUtil.getJSONArray(oRegionConfigs,"REGIONS",oRegions))
		{
			tU8 u8SizeofRegionlist = oRegions.size();
			for(tU8 u8RegionIndex = 0; u8RegionIndex<u8SizeofRegionlist;u8RegionIndex++)
			{
				ETG_TRACE_USR1(("Region :: %d",(tU8)oRegions[u8RegionIndex].asInt()));
				if(u8RegionCode == (tU8)oRegions[u8RegionIndex].asInt())
				{
					ETG_TRACE_USR1(("Region Matched "));
					std::string sTmp;
					if(TRUE == oParseUtil.getString(oRegionConfigs,"NAME",sTmp))
					{
						ETG_TRACE_USR1(("Returning %s as Region ",sTmp.c_str()));
						sRegionName = sTmp;
						return TRUE;
					}

				}
			}
		}

	}

	return FALSE;
}

tBool MPDT_Config_Parsers::bGetTcuType(const tU8 u8OEMName,const std::string sArchitecture, std::string& sTcuType)
{
	ETG_TRACE_USR1(("MPDT_Config_Parsers::bGetTcuType() entered"));

	Json::Value TcuType;
	tBool bParseStatus = bReadMapItems("Tcu_Type_Map",TcuType);
	if(TRUE == bParseStatus)
	{
		std::string sOEMName;
		if(TRUE == bGetBrandName(sU8ToStr(u8OEMName),sOEMName))
		{
			std::string sKeyString = sOEMName;
			sKeyString.append("_");
			sKeyString.append(sArchitecture);
			bParseStatus = oParseUtil.getString(TcuType,sKeyString.c_str(),sTcuType);
			if(TRUE == bParseStatus)
			{
				return TRUE;
			}

		}

	}
	return FALSE;
}
/*tBool MPDT_Config_Parsers::bReadBrandItem(Json::Value&oAllMsgConfigurations,tU8 u8Brand,Json::Value &tBrand)
{
	std::string sBrandName;
	if(TRUE == bGetBrandName(sU8ToStr(u8Brand),sBrandName))
	{
		tBool parseStatus = oParseUtil.getJSONObject(oAllMsgConfigurations,sBrandName.c_str(),tBrand);
		return parseStatus;
	}

	return FALSE;
}

tBool MPDT_Config_Parsers::bReadEngineTypeItem(Json::Value &tBrand,tU8 u8EngineType,Json::Value &tEngineType)
{
	std::string sVechiletypeName;
	if((TRUE == bGetVehicleModeType(sU8ToStr(u8EngineType),sVechiletypeName)))
	{

		tBool parseStatus = oParseUtil.getJSONObject(tBrand,sVechiletypeName.c_str(),tEngineType);
		return parseStatus;
	}
	return FALSE;
}

tBool MPDT_Config_Parsers::bReadTcuStatusItem(Json::Value& tEngineType,tU8 u8TCUAvailability, Json::Value& tTCUAvailability)
{
	std::string sTcuStatusName;
	if((TRUE == bGetTcuAvailabilityStatus(sU8ToStr(u8TCUAvailability),sTcuStatusName)))
	{
		tBool parseStatus = oParseUtil.getJSONObject(tEngineType,sTcuStatusName.c_str(),tTCUAvailability);
		return parseStatus;
	}
	return FALSE;
}*/

/*tBool MPDT_Config_Parsers::bReadRegion(Json::Value &tTCUAvailability,tU8 u8Region,std::vector<tU16> &oAllowedMsgsList)
{
	std::string sRegionName;
	if((TRUE == bGetRegion(sU8ToStr(u8Region),sRegionName)))
	{
		Json::Value tRegion;
		tBool parseStatus = oParseUtil.getJSONArray(tTCUAvailability,sRegionName.c_str(),tRegion);
		if(TRUE == parseStatus)
		{
			for(unsigned index =0;index<tRegion.size(); index++)
			{
				oAllowedMsgsList.push_back((tU16)tRegion[index].asInt());
			}
			return TRUE;
		}
		return parseStatus;
	}
	else
	{
		return FALSE;
	}
}*/


